(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8719,        255]
NotebookOptionsPosition[      7908,        223]
NotebookOutlinePosition[      8302,        240]
CellTagsIndexPosition[      8259,        237]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 ".NET/Link Example: A \"RealTimeAlgebra\" Dialog\n\n",
 StyleBox["This example demonstrates many basic features of creating \
interactive user interface elements from ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" code. It can be run in a modal way, using ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DoNETModal",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", or modeless, using ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DoNETModeless",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[". This example is a .NET version of the Java-based one that is \
included with J/Link.\n\nTo try this example, evaluate all the initialization \
cells (you can do this with the menu command Kernel/Evaluation/Evaluate \
Initialization). Then go to the Examples section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Section"],

Cell["\<\
Needs[\"NETLink`\"]

CreateWindow[] :=
\tNETBlock[
\t\tModule[{form, trackbar, listener},
\t\t\tInstallNET[];
\t\t\t(* We load some types from which we need to call static members. *)
\t\t\tLoadNETType[\"System.Windows.Forms.ScrollBars\"];
\t\t\tLoadNETType[\"System.Windows.Forms.AnchorStyles\"];
\t\t\tLoadNETType[\"System.Windows.Forms.DockStyle\"];
\t\t\tLoadNETType[\"System.Windows.Forms.FormStartPosition\"];
\t\t\tLoadNETType[\"System.Drawing.FontFamily\"];
\t\t\t(* Now create the form and populate it with components. *)
\t\t\tform = NETNew[\"System.Windows.Forms.Form\"];
\t\t\tform@Text = \"RealTimeAlgebra\";
\t\t\ttrackbar = NETNew[\"System.Windows.Forms.TrackBar\"];
\t\t\ttrackbar@Minimum = 0;
\t\t\ttrackbar@Maximum = 20;
\t\t\ttrackbar@LargeChange = 1;
\t\t\tinText = NETNew[\"System.Windows.Forms.TextBox\"];
\t\t\tinText@Text = \"Expand[(x+1)^a]\";
\t\t\tinText@ScrollBars = ScrollBars`Vertical;
\t\t\toutText = NETNew[\"System.Windows.Forms.TextBox\"];
\t\t\toutText@Multiline = True;
\t\t\t(* The next line is the equivalent of a bitwise-or of flags in a .NET \
language like C#, e.g.:
\t\t\t\t\tScrollBars.Vertical | ScrollBars.Horizontal.
\t\t\t*)
\t\t\toutText@ScrollBars = BitOr[NETObjectToExpression[ScrollBars`Vertical], \
NETObjectToExpression[ScrollBars`Horizontal]];
\t\t\toutText@Font = NETNew[\"System.Drawing.Font\", \
FontFamily`GenericMonospace, 10];
\t\t\toutText@WordWrap = False;
\t\t\toutText@Dock = DockStyle`Fill;
\t\t\ttrackbar@Dock = DockStyle`Top;
\t\t\tinText@Dock = DockStyle`Top;
\t\t\toutText@Parent = form;
\t\t\ttrackbar@Parent = form;
\t\t\tinText@Parent = form;  (* Last one added appears at top of frame. *)
\t\t\tform@StartPosition = FormStartPosition`CenterScreen;
\t\t\t(* Here we wire up the Scroll event to call back into Mathematica and \
execute the scrollFunc function. *)
\t\t\tAddEventHandler[trackbar@Scroll, scrollFunc];
\t\t\tform@Width = 400;
\t\t\tform@Height = 200;
\t\t\t(* inText and outText are globals, because we need to refer to them by
\t\t\t   name in the scrollFunc. They must escape the NETBlock wrapping this \
CreateWindow function,
\t\t\t   hence the call to KeepNETObject. The form object also needs to \
escape the NETBlock, but it
\t\t\t   escapes automatically, as it is the NETBlock's return value.
\t\t\t*)
\t\t\tKeepNETObject[inText, outText];
\t\t\tform
\t\t]
\t]

(* This is what will be called in response to moving the slider position: *)
scrollFunc[trackBar_, eventArgs_] :=
\toutText@Text = Block[{a = trackBar@Value}, \
FixCRLF[ToString[ToExpression[inText@Text]]]]


RealTimeAlgebraModal[] :=
\tNETBlock[
\t\tDoNETModal[CreateWindow[]]
\t]


RealTimeAlgebraModeless[opts___?OptionQ] :=
\tModule[{form},
\t\tform = CreateWindow[];
\t\t(* We use the form's Closing event to specify code to be executed when \
the form
\t\t   is closed. It is important for a modeless form to use the Closing \
event, not the
\t\t   Closed event. The Closing event fires before Closed, and there is \
logic in the Closed
\t\t   event that turns off sharing, so that afterwards no other code that \
calls Mathematica
\t\t   could be executed from .NET.
\t\t   The use here is typical--we clean up the object references that need \
to persist
\t\t   throughout the lifetime of the window. Note that the \
RealTimeAlgebraModeless
\t\t   function is not wrapped in NETBlock. If it were, then the inText and \
outText objects
\t\t   would be released when that NETBlock ended, which happens right after \
the window is
\t\t   displayed. The inText and outText objects escape the NETBlock wrapping \
CreateWindow
\t\t   because KeepNETObject is called on them. But KeepNETObject doesn't \
mean \"keep forever\"--it
\t\t   simply promotes the objects to the \"release\" list of the next \
enclosing NETBlock.
\t\t*)
\t\tAddEventHandler[form@Closing, ReleaseNETObject[inText, outText]&];
\t\tDoNETModeless[form, opts];
\t\t(* We don't need a reference to the form anymore, even though it will \
remain visible and active. *)
\t\tReleaseNETObject[form]
\t]\
\>", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Section"],

Cell[TextData[{
 "This dialog lets you drag a slider to change the value of the varaible ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 " from 0 to 20 and recompute the expression in the top text panel.\n\nThis \
runs the dialog in a modal way:"
}], "Text"],

Cell["RealTimeAlgebraModal[]", "Input"],

Cell["\<\
Try entering Print[a] or  in the top panel and dragging the slider. Notice \
how the output appears in the notebook. Close the window to end the program.

For comparison, next run the dialog in a modeless way:\
\>", "Text"],

Cell["RealTimeAlgebraModeless[]", "Input"],

Cell[TextData[{
 "Note how you can continue to use the front end for computations while the \
RealTimeAlgebra window is up.\n\nTry Print[a] in the upper panel now. Note \
that the Print output does not appear in the front end. When using \
ShareKernel, which is how modeless interfaces are implemented, the .NET link \
is the kernel's $ParentLink while the slider is being dragged, so all \
side-effect output gets sent to .NET, where it is discarded by the internal \
code used for event callbacks. You can get the output to appear in the front \
end by using ShareFrontEnd. ShareFrontEnd is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that turns on sharing of the front end between the kernel and the \
link to .NET, but it is also an option to DoNETModeless, so you will rarely \
need to call ShareFrontEnd as a function.\n\nClose the previous modeless \
window and then try this:"
}], "Text"],

Cell["RealTimeAlgebraModeless[ShareFrontEnd -> True]", "Input"],

Cell["\<\
Now putting Plot[Sin[a x],{x,0,2Pi}] in the upper panel and dragging the \
slider will cause plots to appear in the front end.

After you are finished, close the RealTimeAlgebra window and front end \
sharing will be turned off.\
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{933, 594},
WindowMargins->{{-3, Automatic}, {Automatic, 2}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1213, 33, 238, "Title"],
Cell[CellGroupData[{
Cell[1828, 60, 23, 0, 67, "Section"],
Cell[1854, 62, 4130, 106, 1506, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[6021, 173, 27, 0, 37, "Section"],
Cell[6051, 175, 264, 6, 56, "Text"],
Cell[6318, 183, 39, 0, 24, "Input"],
Cell[6360, 185, 233, 5, 56, "Text"],
Cell[6596, 192, 42, 0, 24, "Input"],
Cell[6641, 194, 918, 15, 131, "Text"],
Cell[7562, 211, 63, 0, 24, "Input"],
Cell[7628, 213, 252, 6, 56, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

